/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sam;

import com.quantumdata.sam.MainGui;
import com.quantumdata.std.IQDConsole;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.SocketConnection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import javax.swing.UIManager;

public final class SignalAnalysisModule
extends JApplet
implements IQDConsole {
    private static final long serialVersionUID = 1L;
    public static SignalAnalysisModule sam;
    public static boolean runningAsApplet;
    public static RemoteInstrument ri;
    public static String generatorIP;

    public static void main(String[] stringArray) {
        sam = new SignalAnalysisModule();
        runningAsApplet = false;
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.setTitle("Signal Analysis Module+  Version 1.1");
        jFrame.getContentPane().add(sam);
        jFrame.setSize(1020, 768);
        sam.init();
        jFrame.setVisible(true);
        sam.start();
    }

    public void init() {
        sam = this;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        MainGui.createGUI(this);
        try {
            generatorIP = this.getCodeBase().getHost();
        }
        catch (NullPointerException nullPointerException) {
            String string = null;
            while (string == null || string.equals("")) {
                string = (String)JOptionPane.showInputDialog(this, "Connect to.....", "Connect to Analyzer...", -1, null, null, "192.168.254.");
            }
            generatorIP = string;
        }
    }

    public void start() {
        new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Calendar calendar = Calendar.getInstance();
                Date date = calendar.getTime();
                String string = DateFormat.getDateTimeInstance(2, 2).format(date);
                MainGui.setQDLogoText(string);
            }
        }).start();
        this.println("Connecting to " + generatorIP);
        SocketConnection socketConnection = new SocketConnection(generatorIP);
        ri = new RemoteInstrument(socketConnection, this);
        try {
            ri.connect();
        }
        catch (InstrumentException instrumentException) {
            instrumentException.printStackTrace();
        }
    }

    public void stop() {
        ri.disconnect();
    }

    public void println(String string) {
        System.out.println(string);
        MainGui.getStatus().setText(string);
    }

    static {
        runningAsApplet = true;
    }
}

